capture log close
args database linkage
* running for CPRD GOLD, `strata', primary care only as practice
log using "$logdir\an_timeseries_graphs_`database'_`linkage'", replace
/*******************************************************************************
TIME SERIES GRAPH - STUDY POPULATION ONLY
*******************************************************************************/

/*foreach strata in chronicresp diab_perm chronic_cardiac cerebrovascular vte learning neuro dementia liver ra psoriasis asthma  /*lupus cancer1yr*/ {
local group = "binary"
if "`strata'" == "cancerlyr" local group = "cancer"
*/



local group = "demographics"
local strata = "studypop"
local substrata = .


/*create local for IRR terms to add to graph*/
use "$estimatedir/an_timeseries_estimates_`group'_`strata'_`database'_`linkage'.dta", clear

cap estimates use "$estimatedir\an_glm_estimates_demographics_studypop_all_`database'_`linkage'"
local irr = exp(_b[1.pandemic])
local lci = exp(_b[1.pandemic]-invnorm(0.975)*_se[1.pandemic])
local uci = exp(_b[1.pandemic]+invnorm(0.975)*_se[1.pandemic])
local result  = string(`irr', "%9.2fc") + " (" + string(`lci', "%9.2fc") + "-" + string(`uci', "%9.2fc") + ")"

test 1.pandemic
local pvalue = `r(p)'

local pstring = string(`pvalue', "%9.2fc")
if `pvalue' < 0.01 local pstring = "<0.01" 



/*graph names*/
include "$dodir\inc_strata_names.do"

/*
*Display observed (smooth spline) vs expected (year & season model)
line n_spline weekfrom, lc(red) || line n_usingPREdata weekfrom, lc(gs7) || scatter deaths weekfrom, msize(vsmall) ,  xline(269, lp(dash)) name(observedexpected, replace) legend(label(1 "observed (spline smoothed)") label(2 "expected from year/season model") )
*week 269 = Feb 26th 2020
*graph export "$resultdir/an_timeseries_graphs_postpre_temp.emf", replace
*/

gen n_splinepermill = n_spline/denommillions
gen n_usingPREdatapermill = n_usingPREdata/denommillions
gen deathspermill = deaths/denommillions



*numbers for total excess mortality box
preserve

import excel using "$resultdir\an_table1_`database'_`linkage'.xlsx", clear

keep if A == "Overall"
list F
levelsof F, local(F)
local totalexcessstr = `F'

levelsof G, local(G)
local percentexcessstr = `G'

restore


*x axis range
local endday = ${studyend_`linkage'} - d(01/01/2020)
local endweek = floor(`endday'/7)
di as yellow "end week: `endweek'"
keep if week <= `endweek'

*y axis range
*variable
qui summ n_splinepermill
/*
local ymax = ceil(r(max)/1000) * 1000
if `ymax' <= 1000 local yint = 200
if `ymax' > 1000 & `ymax' < 3000 local yint = 500
if `ymax' >= 3000 & `ymax' < 10000 local yint = 1000
if `ymax' >=10000 local yint = 5000
*/
local ymax = 900

/*
/*fixed to dementia*/
local ymax = 10000
local yint = 1000
*/
local yint = 200

line n_splinepermill week if year == 2015, lc(gs10) /*lpattern(dash_dot)*/ || /// Observed in recent years (spline smoothed)
line n_splinepermill week if year == 2016, lc(gs10) /*lpattern (dash)*/  || ///
line n_splinepermill week if year == 2017, lc(gs10) /*lpattern(longdash_dot)*/ || ///
line n_splinepermill week if year == 2018, lc(gs10) /*lpattern(longdash)*/  || ///
line n_splinepermill week if year == 2019, lc(gs10) /*lpattern(solid)*/  || ///
line n_splinepermill week if year == 2020, lc(red)   || /// Observed in 2020 (spline smoothed)
line n_usingPREdatapermill week if year == 2020, lc(gs1) || /// Expected in 2020 (year season model)
rarea n_usingPREdatapermill n_splinepermill week if year == 2020, color(red%50) lwidth(none) || /// Total excess deaths until end of study period
scatter deathspermill week if year == 2020, msize(vsmall) mcol(gs10) || /// Observed in 2020 (scatter)
, xline(10, lp(dash)) /// start of pandemic
xline($wave1end, lp(dash)) /// end of pandemic
title("`name'") ///
xtitle("") ///
xscale(range(1 `endweek') noline) ///
xlabel(none) ///
yline(0, lc(black)) /// replaces X axis
ytitle("deaths per million", size(small)) ///
yscale(range(-10 `ymax')) ///
ylab(0(`yint')`ymax', labsize(small)) ///
graphregion(color(white))	/// get rid of rubbish grey/blue around graph
legend(off) ///
text(-5 1 "Jan", place(s) size(small)) ///
text(-5 11 "March", place(s) size(small)) ///
text(-5 19 "May", place(s) size(small)) ///
text(-5 27 "July", place(s) size(small)) ///
text(-5 48 "Dec", place(s) size(small)) ///
text(`ymax' 16 "Excess deaths in Wave 1 per" "million person weeks (95% CI):"  "`totalexcessstr'" " " "Adjusted rate ratio (95% CI)" "comparing mortality before" "and during wave 1:" "`result'", place(s) size(small)) ///
name("`strata'", replace)
/*alternatively could label end of data collection period*/




graph export "$resultdir\an_timeseries_graphs_`strata'_`database'_`linkage'.emf", replace

*text(`ymax' 16 "excess deaths per million person" "weeks (95% CI): `totalexcessstr'" "plus % of expected (95% CI):" "`percentexcessstr'" " " "adjusted rate ratio (95% CI)" "comparing mortality before" "and during wave 1:" "`result'", place(s) size(small)) ///


/*

*/