capture log close
args database linkage

log using "$logdir\an_timeseries_estimates_lifestyle_`database'_`linkage'.txt", text replace


/*******************************************************************************
ESTIMATE TIME SERIES DATA
*******************************************************************************/


foreach strata in bmi /*smoking*/ {

capture confirm file "$datadir\cr_weeklycounts_`strata'_gold_`linkage'.dta"
if _rc == 0 di as yellow "recode to use above file instead of individual files"

if "`strata'" == "smoking" local max = 2
if "`strata'" == "bmi" local max = 4

	forvalues i = 0/`max' { 

		if "`database'" == "combined" {
		use "$datadir/cr_weeklycounts_`strata'_`i'_gold_`linkage'.dta", clear
		append using "$datadir/cr_weeklycounts_`strata'_`i'_aurum_`linkage'.dta"
		}
		else {
			use "$datadir/cr_weeklycounts_`strata'_`i'_`database'_`linkage'.dta", clear
			}
		
		*combine BMI categories 4 and 5
		if "`strata'" == "bmi" & `i' == 4 {
			if "`database'" == "combined" {
				append using "$datadir/cr_weeklycounts_`strata'_5_gold_`linkage'.dta"
				append using "$datadir/cr_weeklycounts_`strata'_5_aurum_`linkage'.dta"
				}
			else {
				append using "$datadir/cr_weeklycounts_`strata'_5_`database'_`linkage'.dta"
				}
		}
			
		drop if agestratum == 99 /*needed because agestratum == 99 used to include people aged 18 to 39*/ 
		drop if agestratum < 5 /*i.e. less than 40*/
		
		collapse (sum) deaths denominator, by(year week)
		pause
		include "$dodir\inc_an_glm_prepare.do"
		local autocorrelation = 0
		local substrata = `i'
		include "$dodir\inc_an_timeseries_estimates.do"
		gen substrata = `i'
			if `i' > 0 append using "$estimatedir/an_timeseries_estimates_lifestyle_`strata'_`database'_`linkage'.dta"
			save "$estimatedir/an_timeseries_estimates_lifestyle_`strata'_`database'_`linkage'.dta", replace
			pause
		}
	
	
	if "`database'" == "combined" {
	use "$datadir/cr_weeklycounts_`strata'_99_gold_`linkage'.dta", clear
	append using "$datadir/cr_weeklycounts_`strata'_99_aurum_`linkage'.dta"
	}
	else {
		use "$datadir/cr_weeklycounts_`strata'_99_`database'_`linkage'.dta", clear
		}
		
	drop if agestratum == 99 /*needed because agestratum == 99 used to include people aged 18 to 39*/ 
	drop if agestratum < 5 /*i.e. less than 40*/
	
	collapse (sum) deaths denominator, by(year week)
	include "$dodir\inc_an_glm_prepare.do"
	local autocorrelation = 0
	local substrata = 99
	include "$dodir\inc_an_timeseries_estimates.do"
	gen substrata = 99
	append using "$estimatedir/an_timeseries_estimates_lifestyle_`strata'_`database'_`linkage'.dta"
	save "$estimatedir/an_timeseries_estimates_lifestyle_`strata'_`database'_`linkage'.dta", replace
	pause
		
	}