capture log close
args database linkage

log using "$logdir\an_timeseries_estimates_demographics_`database'_`linkage'.txt", text replace


/*******************************************************************************
ESTIMATE TIME SERIES DATA
*******************************************************************************/
if "`database'" == "combined" {
	use "$datadir/cr_weeklycounts_region_gold_`linkage'.dta", clear
	append using "$datadir/cr_weeklycounts_region_aurum_`linkage'.dta"
	}
	else {
		use "$datadir/cr_weeklycounts_region_`database'_`linkage'.dta", clear
		}

drop if agestratum == 99 /*needed because agestratum == 99 used to include people aged 18 to 39*/ 
drop if agestratum < 5 /*i.e. less than 40*/

*change 8 to 10 year categories - model doesn't fit very well otherwise
recode agestratum 5/6=16 7/8=17 9/10=18 11/12=19 13/15=20
label define agestratum10 16 "40 to 49" 17 "50 to 59" 18 "60 to 69" 19 "70 to 79" 20 "80 plus"
label values agestratum agestratum10
tab agestratum, m

replace region = 4 if region == 6 /*combine East midlands with East of England*/
tempfile temp
save `temp'


***overall study population

collapse (sum) deaths denominator, by(year week) 
local strata = "studypop"
include "$dodir\inc_an_glm_prepare.do"
local autocorrelation = 0
include "$dodir\inc_an_timeseries_estimates.do"
pause
if "`database'" == "combined" {
	include "$dodir\inc_an_timeseries_estimates_spline.do"
	}
pause
gen substrata = 1

save "$estimatedir/an_timeseries_estimates_demographics_studypop_`database'_`linkage'.dta", replace


***other demographics and lifestyle
foreach strata in agestratum region genderstratum   {
use `temp', clear

qui sum `strata'

local imin = `r(min)'
local imax = `r(max)'

forvalues i = `imin'/`imax' {
	if  "`strata'" == "region" & `i' == 6 continue
	use `temp', clear
	keep if `strata' == `i'
	collapse (sum) deaths denominator, by(year week)
	*local splinesneeded = 0
	include "$dodir\inc_an_glm_prepare.do"
	local autocorrelation = 0
	include "$dodir\inc_an_timeseries_estimates.do"
	gen substrata = `i'
	if `i' > `imin' append using "$estimatedir/an_timeseries_estimates_demographics_`strata'_`database'_`linkage'.dta"
	save "$estimatedir/an_timeseries_estimates_demographics_`strata'_`database'_`linkage'.dta", replace
	}
	
}

if "`database'" == "combined" & "`linkage'" == "primary" local ethextra = "eth_lon eth_nonlon"
foreach strata in urban_rural deprivation ethnicity `ethextra'  {
	noi di as yellow "`strata'"
	pause
	
	if "`database'" == "combined" {
	use "$datadir/cr_weeklycounts_`strata'_gold_`linkage'.dta", clear
	append using "$datadir/cr_weeklycounts_`strata'_aurum_`linkage'.dta"
	}
	else {
		use "$datadir/cr_weeklycounts_`strata'_`database'_`linkage'.dta", clear
		}
		
	if "`strata'" == "urban_rural" replace urban_rural = 1 if urban_rural == 3 /*mixed urban_rural in NI becomes urban = largest category*/
	if "`strata'" == "ethnicity" | "`strata'" == "eth_lon" | "`strata'" == "eth_nonlon" replace ethnicity = 3 if ethnicity == 4 /*include "mixed" in other*/
	if "`strata'" == "eth_lon" | "`strata'" == "eth_nonlon" rename ethnicity `strata'
	
	drop if agestratum == 99
	drop if agestratum < 5 /*i.e. less than 40*/
	tempfile temp
	save `temp'
	
	qui sum `strata' if `strata' != 99
	local imin = `r(min)'
	local imax = `r(max)'

	forvalues i = `imin'/`imax' {
		noi di as yellow "`strata' `i'"
		use `temp', clear
		keep if `strata' == `i'
		collapse (sum) deaths denominator, by(year week)
		include "$dodir\inc_an_glm_prepare.do"
		local autocorrelation = 0
		include "$dodir\inc_an_timeseries_estimates.do"
		gen substrata = `i'
		if `i' > `imin' append using "$estimatedir/an_timeseries_estimates_demographics_`strata'_`database'_`linkage'.dta"
		save "$estimatedir/an_timeseries_estimates_demographics_`strata'_`database'_`linkage'.dta", replace
		pause
		}
		
	if "`strata'" == "ethnicity" | "`strata'" == "eth_lon" | "`strata'" == "eth_nonlon" {
		use `temp', clear
		keep if `strata' == 99
		collapse (sum) deaths denominator, by(year week)
		include "$dodir\inc_an_glm_prepare.do"
		local autocorrelation = 0
		include "$dodir\inc_an_timeseries_estimates.do"
		gen substrata = 99
		append using "$estimatedir/an_timeseries_estimates_demographics_`strata'_`database'_`linkage'.dta"
		save "$estimatedir/an_timeseries_estimates_demographics_`strata'_`database'_`linkage'.dta", replace
		}
	
	}
	

