capture log close
args database linkage

/*******************************************************************************
ESTIMATE TIME SERIES DATA
*******************************************************************************/

foreach strata in cancer3mo cancer3mo1yr haemever nonhaemever haem1yr nonhaem1yr haem5yr nonhaem5yr {

	local group = "cancer"

	if "`database'" == "combined" {
	use "$datadir/cr_weeklycounts_`group'_`strata'_gold_`linkage'.dta", clear
	append using "$datadir/cr_weeklycounts_`group'_`strata'_aurum_`linkage'.dta"
	}
	
	else {
		use "$datadir/cr_weeklycounts_`group'_`strata'_`database'_`linkage'.dta", clear
		}
		
	capture log close
	log using "$logdir\an_timeseries_estimates_`group'_`strata'_`database'_`linkage'.txt", replace text
	*include "$dodir\inc_an_timeseries_estimates_byagesex.do"
	drop if agestratum == 99
	drop if agestratum < 5 /*i.e. less than 40*/
	collapse (sum) deaths denominator, by(year week) /*needed because agestratum == 99 used to include people aged 18 to 39*/ 

	include "$dodir\inc_an_glm_prepare.do"
	local autocorrelation = 0
	include "$dodir\inc_an_timeseries_estimates.do"
	gen substrata = 1
	save "$estimatedir/an_timeseries_estimates_`group'_`strata'_`database'_`linkage'.dta", replace 	
	capture log close
	pause
	}

