capture log close
args database linkage

/*******************************************************************************
ESTIMATE TIME SERIES DATA
*******************************************************************************/

foreach strata in cancer1yr neuro ra lupus psoriasis asthma ckd multimorbidity learning diab_perm dementia chronicresp chronic_cardiac cerebrovascular vte ht { /*removed immuno and liver*/
	if "`strata'" == "cancer1yr" {
		local group = "cancer"
		}
		else {
			local group = "binary"
		}
		
	if "`database'" == "combined" {
	use "$datadir/cr_weeklycounts_`group'_`strata'_gold_`linkage'.dta", clear
	count if year > 2014
	assert r(N) == 9672
	append using "$datadir/cr_weeklycounts_`group'_`strata'_aurum_`linkage'.dta"
	count if year > 2014
	assert r(N) == 9672 * 2
	}
	
	else {
		use "$datadir/cr_weeklycounts_`group'_`strata'_`database'_`linkage'.dta", clear
		count if year > 2014
		assert r(N) == 9672
		}
	capture log close
	log using "$logdir\an_timeseries_estimates_`group'_`strata'_`database'_`linkage'.txt", replace text
	*include "$dodir\inc_an_timeseries_estimates_byagesex.do"
	drop if agestratum == 99
	drop if agestratum < 5 /*i.e. less than 40*/
	collapse (sum) deaths denominator, by(year week) /*needed because agestratum == 99 used to include people aged 18 to 39*/ 

	include "$dodir\inc_an_glm_prepare.do"
	local autocorrelation = 0
	include "$dodir\inc_an_timeseries_estimates.do"
	gen substrata = 1
	save "$estimatedir/an_timeseries_estimates_`group'_`strata'_`database'_`linkage'.dta", replace 	
	capture log close
	pause
	}

