capture log close
log using "$logdir\an_glm_table_supplementary_sex.txt", text replace

/********************************************************************************
SUPPLEMENTARY APPENDIX: GLM ESTIMATES FOR SENSITIVITY ANALYSES
*******************************************************************************/

use "$estimatedir\an_glm_processout_combined_primary.dta", clear
keep agegroup group strata substrata strataresult covarpanresult stratapstring covarpanpstring

keep if agegroup == "male"

foreach var in strata covarpan {
	rename `var'result `var'resultmale
	rename `var'pstring `var'pstringmale
	}

drop agegroup
drop if group == ""

tempfile temp
save `temp'

use "$estimatedir\an_glm_processout_combined_primary.dta", clear
keep agegroup group strata substrata strataresult covarpanresult stratapstring covarpanpstring

keep if agegroup == "female"

foreach var in strata covarpan {
	rename `var'result `var'resultfemale
	rename `var'pstring `var'pstringfemale
	}

drop if group == ""

merge 1:1 group strata substrata using `temp', keepusing(group strata substrata strataresult covarpanresult stratapstring covarpanpstring)
*assert _merge == 3 if strata != "agestratum"
drop _merge

local cat1 = "male"
local cat2 = "female"

include "$dodir\inc_an_glm_table_supplementary.do"

foreach var in strata covarpan {
	label var `var'resultmale "Male"
	label var `var'resultfemale "Female"
}

export excel using "$resultdir\an_glm_table_supplementary_sex.xlsx", firstrow(varlabels) replace

capture log close