capture log close
log using "$logdir\an_glm_table_supplementary_agegps.txt", text replace

/********************************************************************************
SUPPLEMENTARY APPENDIX: GLM ESTIMATES FOR SENSITIVITY ANALYSES
*******************************************************************************/

use "$estimatedir\an_glm_processout_combined_primary.dta", clear
keep if agegroup == "all"
drop if strata == "london"
keep group strata substrata strataresult covarpanresult stratapstring covarpanpstring

replace substrata = "1" if substrata == "c" /*agelinear*/
replace group = "binary" if strata == "cancer1yr"

*use inc_strata_names to get labels
gen keep = 0
gen grouplabel = ""
gen stratalabel = ""
gen substratalabel = ""
local groups = "lifestyle binary demographics"
foreach g of local groups {
    noi di as yellow "`g'"
	replace keep = 1 if group == "`g'"
    levelsof strata if group == "`g'", local(strataaa)
	foreach strata of local strataaa {
	    noi di as yellow "`strata'"
	    levelsof substrata if strata == "`strata'" & group == "`g'", local(substrataaa)
		foreach substrata of local substrataaa {
		    noi di as yellow "`substrata'"
		    qui include "$dodir\inc_strata_names.do"
			replace grouplabel = "`groupname'" if  group == "`g'" & strata == "`strata'" & substrata == "`substrata'"
			replace stratalabel = "`strataname'" if  group == "`g'" & strata == "`strata'" & substrata == "`substrata'"
			replace substratalabel = "`substrataname'" if  group == "`g'" & strata == "`strata'" & substrata == "`substrata'"
		}
}
}

replace substratalabel = stratalabel if group == "binary"
replace stratalabel = grouplabel if group == "binary"
replace grouplabel = "Comorbidity" if group == "binary"

keep if keep == 1
drop keep
replace grouplabel = "DEMOGRAPHICS" if group == "demographics"
replace grouplabel = "HEALTH BEHAVIOURS / INDICATORS" if group == "lifestyle"
replace grouplabel = "MEDICAL CONDITION"  if group == "binary"

drop group strata substrata
*order and add in row gaps
order grouplabel stratalabel substratalabel strataresult stratapstring covarpanresult covarpanpstring
replace substratalabel = "Z.Missing" if substratalabel == "Missing"
replace substratalabel = "1.<18.5 (Underweight)" if substratalabel == "<18.5 (Underweight)"
sort grouplabel stratalabel substratalabel	

by group stratalabel: ingap, gapindicator(gap)

*replace substratalabel = -1 if gap == 1
replace substratalabel = stratalabel if gap == 1
drop gap

by group: ingap, gapindicator(gap)
*replace substrata = -2 if gap == 1
replace substratalabel = grouplabel if gap == 1
drop gap

replace substratalabel = "Missing" if substratalabel == "Z.Missing"
replace substratalabel = "<18.5 (Underweight)" if substratalabel == "1.<18.5 (Underweight)"

rename substratalabel stratfactor

keep stratfactor strataresult covarpanresult /*decided to drop p-values*/
order stratfactor strataresult covarpanresult

label variable stratfactor "Factor"
label variable strataresult "Before Wave 1"
label variable covarpanresult "During Wave 1"

export excel using "$resultdir\an_glm_table_supplementary_missing.xlsx", firstrow(varlabels) replace

capture log close