capture log close
log using "$logdir\an_glm_table_supplementary_linkages.txt", text replace

/********************************************************************************
SUPPLEMENTARY APPENDIX: GLM ESTIMATES FOR SENSITIVITY ANALYSES
*******************************************************************************/

use "$estimatedir\an_glm_processout_combined_primary.dta", clear
keep if agegroup == "all"
keep group strata substrata strataresult covarpanresult stratapstring covarpanpstring

foreach var in strata covarpan {
	rename `var'result `var'resultprimary
	rename `var'pstring `var'pstringprimary
	}

drop if group == ""
tempfile temp
save `temp'

use "$estimatedir\an_glm_processout_combined_linked.dta", clear
keep if agegroup == "all"
keep group strata substrata strataresult covarpanresult stratapstring covarpanpstring

foreach var in strata covarpan {
	rename `var'result `var'resultlinked
	rename `var'pstring `var'pstringlinked
	}
	
	
merge 1:1 group strata substrata using "`temp'"
drop _merge

local cat1 = "primary"
local cat2 = "linked"
	
include "$dodir\inc_an_glm_table_supplementary.do"

foreach var in strata covarpan {
	label var `var'resultprimary "Primary care only"
	label var `var'resultlinked "Linked data"
}

export excel using "$resultdir\an_glm_table_supplementary_linkages.xlsx", firstrow(varlabels) replace

capture log close