capture log close
log using "$logdir\an_glm_table_supplementary_ethnicity.txt", text replace

/********************************************************************************
ETHNICITY - LONDON AND ELSEWHERE
*******************************************************************************/

use "$estimatedir\an_glm_processout_combined_primary.dta", clear
keep if agegroup == "all"
keep strata substrata strataresult covarpanresult
keep if strata == "eth_lon" | strata == "eth_nonlon" | strata == "ethnicity"

tempfile temp
preserve
keep if strata == "ethnicity"
foreach var in strata covarpan {
	rename `var'result `var'resultuk
	}
	
save `temp'
restore
preserve
keep if strata == "eth_lon"
foreach var in strata covarpan {
	rename `var'result `var'resultlondon
	}
merge 1:1 substrata using `temp', nogen noreport

save `temp', replace
restore
keep if strata == "eth_nonlon"
foreach var in strata covarpan {
	rename `var'result `var'resultotheruk
	}
merge 1:1 substrata using `temp', nogen noreport

drop strata

local strata = "ethnicity"
gen substratalabel = ""
levelsof substrata, local(substrataaa)
foreach substrata of local substrataaa {
	noi di as yellow "`substrata'"
	qui include "$dodir\inc_strata_names.do"
	replace substratalabel = "`substrataname'" if substrata == "`substrata'"
	}
	
drop substrata
order substratalabel strataresultuk strataresultlondon strataresultotheruk covarpanresultuk covarpanresultlondon covarpanresultotheruk
label variable substratalabel "Ethnicity"

foreach var in strata covarpan {
	label var `var'resultuk "Overall"
	label var `var'resultlondon "London only"
	label var `var'resultotheruk "Other"
}

insobs 1, before(1)
replace strataresultlondon = "Before Wave 1" in 1
replace covarpanresultlondon = "During Wave 1" in 1

export excel using "$resultdir\an_glm_table_supplementary_ethnicity.xlsx", firstrow(varlabels) replace

capture log close