capture log close
log using "$logdir\an_glm_table_supplementary_databases.txt", text replace

/********************************************************************************
SUPPLEMENTARY APPENDIX: GLM ESTIMATES FOR SENSITIVITY ANALYSES
*******************************************************************************/

use "$estimatedir\an_glm_processout_gold_primary.dta", clear
keep group strata substrata strataresult covarpanresult stratapstring covarpanpstring

foreach var in strata covarpan {
	rename `var'result `var'resultgold
	rename `var'pstring `var'pstringgold
	}

drop if group == ""
merge 1:1 group strata substrata using "$estimatedir\an_glm_processout_aurum_primary.dta", keepusing(group strata substrata strataresult covarpanresult stratapstring covarpanpstring)
drop if _merge ==2
drop _merge

foreach var in strata covarpan {
	rename `var'result `var'resultaurum
	rename `var'pstring `var'pstringaurum
	}
	
local cat1 = "gold"
local cat2 = "aurum"
	
include "$dodir\inc_an_glm_table_supplementary.do"

foreach var in strata covarpan {
	label var `var'resultgold "CPRD GOLD"
	label var `var'resultaurum "CPRD Aurum"
}

export excel using "$resultdir\an_glm_table_supplementary_databases.xlsx", firstrow(varlabels) replace

capture log close