capture log close
log using "$logdir\an_glm_table_supplementary_agegps.txt", text replace

/********************************************************************************
SUPPLEMENTARY APPENDIX: GLM ESTIMATES FOR SENSITIVITY ANALYSES
*******************************************************************************/

use "$estimatedir\an_glm_processout_combined_primary.dta", clear
keep agegroup group strata substrata strataresult covarpanresult stratapstring covarpanpstring

keep if agegroup == "young"

foreach var in strata covarpan {
	rename `var'result `var'resultyoung
	rename `var'pstring `var'pstringyoung
	}

drop agegroup
drop if group == ""

tempfile temp
save `temp'

use "$estimatedir\an_glm_processout_combined_primary.dta", clear
keep agegroup group strata substrata strataresult covarpanresult stratapstring covarpanpstring

keep if agegroup == "old"

foreach var in strata covarpan {
	rename `var'result `var'resultold
	rename `var'pstring `var'pstringold
	}

drop if group == ""

merge 1:1 group strata substrata using `temp', keepusing(group strata substrata strataresult covarpanresult stratapstring covarpanpstring)
assert _merge == 3 if strata != "agestratum"
drop _merge

local cat1 = "young"
local cat2 = "old"

include "$dodir\inc_an_glm_table_supplementary.do"

foreach var in strata covarpan {
	label var `var'resultyoung "40 to 69"
	label var `var'resultold "70 or older"
}

export excel using "$resultdir\an_glm_table_supplementary_agegps.xlsx", firstrow(varlabels) replace

capture log close