capture log close
args database linkage autocorrelation

/*******************************************************************************
ESTIMATE TIME SERIES DATA
*******************************************************************************/

capture program drop glmprocessout

program glmprocessout
	args group strata substrata agegp database linkage missing autocorrelation
	di as yellow "group: `group'"
	di as yellow "strata: `strata'"
	di as yellow "substrata: `substrata'"
	di as yellow "agegp: `agegp'"
	di as yellow "database: `database'"
	di as yellow "linkage: `linkage'"
	di as yellow "missing: `missing'"
	
	noisily {
	
	estimates use "$estimatedir\an_glm_estimates_`group'_`strata'_`agegp'_`database'_`linkage'"
	
	*lowest category = 1 unless age group, ethnicity, london or lifestyle
		if "`strata'" == "agestratum" {
			if "`agegp'" == "old" {
				local i = 11
				}
				else {
					local i = 5
					if "`agegp'" == "young" local substrata = 10
					}			
			}
			else {
				local i = 1
				}
		if "`group'" == "lifestyle" | "`strata'" == "ethnicity" | "`strata'" == "eth_lon" | "`strata'" == "eth_nonlon" | "`strata'" == "london" local i = 0
		
	
	*export estimates for each category
	local numlist ""
		forvalues x = `i'/`substrata' {
			local numlist = "`numlist' `x'"
			}
		local numlist = "`numlist' `missing'"
		
	di as yellow "`numlist'"
	if "`strata'" == "agelinear" local numlist = "c"
	
		foreach x of local numlist {
			di as yellow "x: `x'"
			if "`strata'" == "region" & "`x'" == "6" continue
			capture test `x'.`strata'#1.pandemic
			/*missing category e.g. regions for gold only / aurum only*/
			if _rc > 0 {
				assert "`strata'" == "region" & "`linkage'" != "combined"
			    post results ("`group'") ("`strata'") ("`x'") ("`agegp'") (.) (.) (.) (.) (.) (.) (.) (.) (.) (.) (.) (.) (.)
				}
			else {
				local intp = `r(p)'
				test 1.pandemic
				local panp = `r(p)'
				test `x'.`strata'
				local stratap = `r(p)'
				
				lincom `x'.`strata' + `x'.`strata'#1.pandemic
				local covarpanbeta = `r(estimate)'
				local covarpanse = `r(se)'
				local covarpanp = `r(p)'

				estimates use "$estimatedir\an_glm_estimates_`group'_`strata'_`agegp'_`database'_`linkage'"
				
				post results ("`group'") ("`strata'") ("`x'") ("`agegp'") (_b[`x'.`strata']) (_se[`x'.`strata']) (`panp') (_b[1.pandemic]) (_se[1.pandemic]) (`panp') (_b[`x'.`strata'#1.pandemic]) (_se[`x'.`strata'#1.pandemic]) (`intp') (`covarpanbeta') (`covarpanse') (`covarpanp') (e(converged))
			} /*else*/
		} /*foreach*/
		
	}
end
			
			
cap postutil clear
tempfile results  
postfile results str20 group str20 strata str5 substrata str6 agegroup stratabeta stratasebeta stratapvalue panbeta pansebeta panpvalue intbeta intsebeta intpvalue covarpanbeta covarpansebeta covarpanpvalue converged using `results'



if "`database'" == "combined" & "`linkage'" == "primary" {
    local agegroups = "young old all male female"
	}
	else {
	    local agegroups = "all"
	}

foreach agegp of local agegroups {
	
	di as yellow "`agegp'"
	
	***binary comorbidities
	foreach strata in neuro ra lupus psoriasis asthma ht ckd multimorbidity learning diab_perm dementia chronicresp chronic_cardiac cerebrovascular vte { /*removed immuno and liver*/
		di as yellow "`strata'"
		glmprocessout "binary" "`strata'" 1 "`agegp'" "`database'" "`linkage'"
		}
	
	foreach strata in cancer1yr {
		di as yellow "`strata'"
		glmprocessout "cancer" "cancer1yr" 1 "`agegp'" "`database'" "`linkage'"
		}
		
	***demographics
	estimates use "$estimatedir\an_glm_estimates_demographics_studypop_`agegp'_`database'_`linkage'"
	test 1.pandemic
	local panp = `r(p)'
	post results ("`group'") ("`strata'") ("1") ("`agegp'") (.) (.) (.) (_b[1.pandemic]) (_se[1.pandemic]) (.) (.) (.) (.) (.) (.) (.) (e(converged))
	
	glmprocessout "demographics" "agestratum" "15" "`agegp'" "`database'" "`linkage'"
	glmprocessout "demographics" "agelinear" "1" "`agegp'" "`database'" "`linkage'"
	glmprocessout "demographics" "region" "13" "`agegp'" "`database'" "`linkage'"
	glmprocessout "demographics" "london" "1" "`agegp'" "`database'" "`linkage'"
	if "`agegp'" != "male" & "`agegp'" != "female" {
		glmprocessout "demographics" "genderstratum" "2" "`agegp'" "`database'" "`linkage'"
		}
	glmprocessout "demographics" "urban_rural" "2" "`agegp'" "`database'" "`linkage'"
	glmprocessout "demographics" "deprivation" "5" "`agegp'" "`database'" "`linkage'"
	

	if "`database'" == "combined" & "`linkage'" == "primary" & "`agegp'" == "all" local ethextra = "eth_lon eth_nonlon"
	foreach strata in ethnicity `ethextra'  {
		glmprocessout "demographics" "`strata'" "3" "`agegp'" "`database'" "`linkage'"	"99"
		}
	
	***cancer
	if "`database'" == "combined" & "`agegp'" == "all" {
		foreach strata in cancer3mo cancer3mo1yr haemever nonhaemever haem1yr nonhaem1yr haem5yr nonhaem5yr {
			glmprocessout "cancer" "`strata'" "1" "`agegp'" "`database'" "`linkage'"
			}
		}
		
	***lifestyle / health behaviours / indicators
	glmprocessout "lifestyle" "smoking" "2" "`agegp'" "`database'" "`linkage'" "99"
	glmprocessout "lifestyle" "bmi" "4" "`agegp'" "`database'" "`linkage'" "99"
}

postclose results

use `results', clear

foreach term in strata pan int covarpan {
	gen `term'irr = exp(`term'beta)
	gen `term'lci = exp(`term'beta-invnorm(0.975)*`term'sebeta)
	gen `term'uci = exp(`term'beta+invnorm(0.975)*`term'sebeta)
	gen `term'result  = string(`term'irr, "%9.2fc") + " (" + string(`term'lci, "%9.2fc") + "-" + string(`term'uci, "%9.2fc") + ")"
	replace `term'result  = string(`term'irr, "%9.1fc") + " (" + string(`term'lci, "%9.1fc") + "-" + string(`term'uci, "%9.1fc") + ")" if `term'irr >=10 
	gen `term'pstring = string(`term'pvalue, "%9.2g") /*2sf*/
	replace `term'pstring = "<0.001" if `term'pvalue < 0.001
	replace `term'pstring = "0" + `term'pstring if `term'pvalue >= 0.001 & `term'pvalue != . /*add leading 0*/
	replace `term'pstring = `term'pstring + "0" if strlen(`term'pstring) == 3 /*add 0 for e.g. 0.5*/
	replace `term'pstring = "" if `term'result == "1.00 (1.00-1.00)"
	replace `term'result = "1.00" if `term'result == "1.00 (1.00-1.00)"
	}

/*remove pandemic term from non-baseline categories for binary/cancer variables*/
foreach var in result pstring irr lci uci {
	capture confirm numeric variable strata`var'
	if _rc == 0 {
		replace pan`var' = . if stratase != 0 & stratabeta != 0 & group != "binary" & group != "cancer"
        }
		else {
			replace pan`var' = "" if stratase != 0 & stratabeta != 0 & group != "binary" & group != "cancer"
			}
	}

save "$estimatedir\an_glm_processout_`database'_`linkage'.dta", replace


capture log close
