capture log close

/*******************************************************************************
GLM GRAPHS - SUPPLEMENTARY APPPENDIX - AGE GROUP ONLY
*******************************************************************************/
local database = "combined"
local linkage = "primary"

use "$estimatedir\an_glm_processout_`database'_`linkage'.dta", clear

drop if group == ""

keep if agegroup == "all"
drop agegroup

keep if strata == "agestratum"


drop group
destring substrata, replace


* make wave 1 result text and p-value strings italic
foreach var in covarpanresult covarpanpstring {
	replace `var' = "{it:" + `var' + "}"
	}


*separate rows for pre- and post-pandemic
expand 2, gen(exp)
gen irrtype = 1 if exp == 0
replace irrtype = 2 if exp == 1
label define irrtypelab 1 "Pre-pandemic" 2 "During Wave 1"
label values irrtype irrtypelab

foreach x in irr lci uci pstring result {
	rename strata`x' `x'
	replace `x' = covarpan`x' if irrtype == 2
	drop covarpan`x'
	}

*add a row between strata
sort strata substrata irrtype
by strata substrata: ingap -1, after
replace exp = -1 if exp == .
gen stratalabrow = 1 if irrtype == 1

*labels for groups and strata
gen stratalabel = ""
gen grouplabel = ""
local strata = "agestratum"

summ substrata if strata == "`strata'" & substrata !=99
local imin = `r(min)'
local imax = `r(max)'
forvalues substrata = `imin'/`imax' {
	qui include "$dodir\inc_strata_names.do"
	di "`substrataname'"
	replace stratalabel = "`substrataname'" if substrata == `substrata' & strata == "`strata'"
	replace grouplabel = "{bf:`strataname'}" if substrata == `substrata' & strata == "`strata'"
	}

rename strata group
rename substrata strata


*add a row for group labels	
gsort -grouplabel
encode grouplabel, generate(_grouporder)
gen grouporder = 0
qui summ _grouporder
local maxgroup = `r(N)'
local i = `maxgroup'
forvalues x = 1/`maxgroup' {
	replace grouporder = `i' if _grouporder == `x'
	local i = `i' - 1
	}

	
gsort grouporder grouplabel -strata -exp
by grouporder grouplabel: ingap -1, after
drop grouporder _grouporder
replace exp = -2 if exp == .

gen grouplabrow = 1 if exp == -2

gen obs = _n /*delete if reinstate headings*/

drop strata


*add row for headings obs
count
insobs 1, after(r(N))
replace obs = _n


*double spacing between IRRs, single spacing for gaps
gen _obs = _n * 2
gen halfrow = 0
replace halfrow = 1 if exp == -1
sort halfrow _obs
replace obs = _n * 2

sort _obs 
replace obs = obs[_n-1] + 1 if exp == -1
drop _obs halfrow

*identify row with headings obs and fill in headings
qui summ obs
global headingobs = r(max)
di $headingobs

gen irrheading ="{bf:RR (95% CI)}" if obs==$headingobs
gen pheading = "{bf:p interaction}" if obs==$headingobs
gen higherriskheading ="{it:(Higher rate)}" if obs==$headingobs
gen lowerriskheading ="{it:(Lower rate)}" if obs==$headingobs

/*common label/headings positions*/
gen plabpos = 120 /*location of p-value*/
gen irrlabpos = 20 /*location of IRR estimates*/
gen grouplabpos = 0.02  /*location of outcome labels*/
gen stratalabpos = 0.02
gen lowerpos = 0.2 /*lower risk label*/
gen higherpos = 1
local xlabticks "0.1 0.5 1 2.5 5 10 20"
local xscalemax 200
local legendtext "order(1 3) label(1 "RR Pre-pandemic") label(3 "RR During Wave 1")"
local size1 "vsmall"
local size2 "vsmall"


	qui summ obs
	local ymax = r(max)
	di "ymax: `ymax'"

	/*******************************************************************************
	#draw graph
	*******************************************************************************/
	
	graph twoway ///
	/// irr and cis (pre-pandemic)
	|| scatter obs irr if irrtype == 1, msymbol(smtriangle) msize(`size1') mcolor(purple) 		/// data points 
		xline(1, lp(solid) lw(vthin) lcolor(black))				/// add ref line
	|| rcap lci uci obs if irrtype == 1, horizontal lw(vthin) col(black) msize(`size2')		/// add the CIs
	/// irr and cis (during pandemic)
	|| scatter obs irr if irrtype == 2, msymbol(smsquare) msize(`size1') mcolor(dkorange) 		/// data points 
	|| rcap lci uci obs if irrtype == 2, horizontal lw(vthin) color(black) msize(`size2')	/// add the CIs	
	/// add results labels
	|| scatter obs irrlabpos, m(i) mlab(result) mlabcol(black) mlabsize(`size2') mlabposition(3)  ///
	/// add p values
	|| scatter obs plabpos if irrtype == 1, m(i) mlab(intpstring) mlabcol(black) mlabsize(`size2') mlabposition(3) ///
	/// The outcome and exposure labels added back in 17th March
	|| scatter obs grouplabpos if grouplabrow == 1, m(i) mlab(grouplabel) mlabcol(black) mlabsize(`size2')  ///
	|| scatter obs stratalabpos if stratalabrow == 1, m(i) mlab(stratalabel) mlabcol(black) mlabsize(`size2') ///
	/// Headings for outcome labels and results
	|| scatter obs plabpos if obs==$headingobs, m(i) mlab(pheading) mlabcol(black) mlabsize(`size2') mlabpos(3) ///
	|| scatter obs irrlabpos if obs==$headingobs, m(i) mlab(irrheading) mlabcol(black) mlabsize(`size2') mlabpos(3) ///
	|| scatter obs lowerpos if obs==$headingobs, m(i) mlab(lowerriskheading) mlabcol(black) mlabsize(`size2') mlabpos(3) ///
	|| scatter obs higherpos if obs==$headingobs, m(i) mlab(higherriskheading) mlabcol(black) mlabsize(`size2') mlabpos(3) ///
	/// graph options
			, ///
			xtitle("RR (95% CI)", size(`size2') margin(0 2 0 0)) 	/// x-axis title - legend off
			xlab(`xlabticks', labsize(`size2') tlength(0.5cm)) /// x-axis tick marks
			xscale(range(1 `xscalemax') log)					///	resize x-axis
			, ylab(none) ytitle("") yscale(r(1 `ymax') off) ysize(8) /// y-axis no labels or title
			graphregion(color(white)) /// get rid of rubbish grey/blue around graph
			legend(`legendtext'  /// legend (1 = first plot, 3 = 3rd plot, 5 = 5th plot)
			size(`size2') rows(1) nobox region(lstyle(none) col(none) margin(zero)) bmargin(zero) pos(5)) ///
			name(agegroup, replace)
	pause
	
	*graph display agegroup, ysize(7.8) margins(zero) /*xsize was 7.8*/
	graph export "$resultdir\an_glm_graphs_agegroup_all_`database'_`linkage'.emf", replace







capture log close


