capture log close
args database linkage agegp

/*******************************************************************************
GLM GRAPHS
*******************************************************************************/

foreach type in demographics binary lifestyle cancer { 

use "$estimatedir\an_glm_processout_`database'_`linkage'.dta", clear

drop if group == ""

keep if agegroup == "`agegp'" /*change this when decide how to present results*/
drop agegroup /*as above*/



if "`type'" == "demographics" drop if strata == "agestratum" | strata == "region" | strata == "eth_lon" | strata == "eth_nonlon" 

if "`type'" == "binary" {
	replace group = "binary" if strata == "cancer1yr"
	drop if strata == "lupus"
	}

keep if group == "`type'"

drop group

replace substrata = "1" if substrata == "c" /*agelinear*/
destring substrata, replace
drop if substrata == 99 /*drop missing categories for main graphs*/


*if "`type'" == "cancer" drop if strata == "cancer1yr"

* make wave 1 result text and p-value strings italic

foreach var in covarpanresult covarpanpstring {
	replace `var' = "{it:" + `var' + "}"
	}


*separate rows for pre- and post-pandemic
expand 2, gen(exp)
gen irrtype = 1 if exp == 0
replace irrtype = 2 if exp == 1
label define irrtypelab 1 "Pre-pandemic" 2 "During Wave 1"
label values irrtype irrtypelab

foreach x in irr lci uci pstring result {
	rename strata`x' `x'
	replace `x' = covarpan`x' if irrtype == 2
	drop covarpan`x'
	}

*add a row between strata
sort strata substrata irrtype
by strata substrata: ingap -1, after
replace exp = -1 if exp == .
gen stratalabrow = 1 if irrtype == 1



*labels for groups and strata
gen stratalabel = ""
gen grouplabel = ""

if "`type'" == "binary" | "`type'" == "cancer" {
	local substrata = 0
	levelsof strata, local(stratasic)
	foreach strata of local stratasic {
		qui include "$dodir\inc_strata_names.do"
		replace stratalabel = "`strataname'" if strata == "`strata'"
		replace grouplabel = "{bf:`groupname'}" if strata == "`strata'"
		}
		if "`type'" == "cancer" replace grouplabel = "{bf:Cancer}" if strata == "cancer1yr"
		if "`type'" == "cancer" replace stratalabel = "In last year" if strata == "cancer1yr"
	}
	

if "`type'" == "demographics" | "`type'" == "demographicssupp" | "`type'" == "lifestyle" {
	if "`type'" == "demographics" local s = "genderstratum agelinear deprivation london urban_rural ethnicity" /*agestratum region*/
	if "`type'" == "lifestyle" local s = "smoking bmi"
	*if "`type'" == "cancer" local s = "oneyr fiveyr ever"

	foreach strata of local s {
		summ substrata if strata == "`strata'" & substrata !=99
		local imin = `r(min)'
		local imax = `r(max)'
		forvalues substrata = `imin'/`imax' {
			qui include "$dodir\inc_strata_names.do"
			di "`substrataname'"
			replace stratalabel = "`substrataname'" if substrata == `substrata' & strata == "`strata'"
			replace grouplabel = "{bf:`strataname'}" if substrata == `substrata' & strata == "`strata'"
			}
		*to add missing category - count if strata == "`strata'" & substrata !=99 and repeat
		}
	*capture drop group
	rename strata group
	rename substrata strata
	}
	
*Group binary demographics to save room on chart
if "`type'" == "demographics" {
	drop if group == "genderstratum" & strata == 2
	drop if group == "london" & strata == 0
	drop if group == "urban_rural" & strata == 1
	replace grouplabel = "{bf:Demographics}" if group == "genderstratum" | group == "london" | group == "urban_rural" | group == "agelinear"
	replace strata = 1 if group == "agelinear"
	replace strata = 2 if group == "genderstratum"
	replace strata = 3 if group == "london"
	replace strata = 4 if group == "urban_rural"
	*drop if grouplabel == "{bf:Demographics}" & exp == -1 & group !="London" /*keep 1 spacing row*/
	}
	
*add a row for group labels	

gsort -grouplabel
encode grouplabel, generate(_grouporder)
gen grouporder = 0
qui summ _grouporder
local maxgroup = `r(N)'
local i = `maxgroup'
forvalues x = 1/`maxgroup' {
	replace grouporder = `i' if _grouporder == `x'
	local i = `i' - 1
	}

	
gsort grouporder grouplabel -strata -exp
by grouporder grouplabel: ingap -1, after
drop grouporder _grouporder
replace exp = -2 if exp == .

gen grouplabrow = 1 if exp == -2

gen obs = _n /*delete if reinstate headings*/
/*graph column and axis headings*/

*gsort -grouplabel strata exp

/*


if "`type'" == "binary" gen strataheading = "{bf:A Comorbidity}" if obs == $headingobs
if "`type'" == "lifestyle" gen strataheading = "{bf:B Health Indicator}" if obs == $headingobs
if "`type'" == "demographics" gen strataheading = "{bf:C Demographics}" if obs == $headingobs
if "`type'" == "cancer" gen strataheading = "{bf:Cancer Definition}" if obs == $headingobs



*/
drop strata
save "$datadir\temp_`type'", replace

}

/*
use "$datadir\temp_lifestyle"
append using "$datadir\temp_demographics"
*/



use "$datadir\temp_demographics", clear
append using "$datadir\temp_lifestyle"
append using "$datadir\temp_binary"

save "$datadir\temp_binarylifedemo", replace

foreach type in binarylifedemo cancer {

use "$datadir\temp_`type'", clear

*add row for headings obs
count
insobs 1, after(r(N))
replace obs = _n


*double spacing between IRRs, single spacing for gaps
gen _obs = _n * 2
gen halfrow = 0
replace halfrow = 1 if exp == -1
sort halfrow _obs
replace obs = _n * 2

sort _obs 
replace obs = obs[_n-1] + 1 if exp == -1
drop _obs halfrow

*identify row with headings obs and fill in headings
qui summ obs
global headingobs = r(max)
di $headingobs

gen irrheading ="{bf:RR (95% CI)}" if obs==$headingobs
gen pheading = "{bf:p interaction}" if obs==$headingobs
gen higherriskheading ="{it:(Higher rate)}" if obs==$headingobs
gen lowerriskheading ="{it:(Lower rate)}" if obs==$headingobs

/*common label/headings positions*/
gen plabpos = 50 /*location of p-value*/
gen irrlabpos = 20 /*location of IRR estimates*/
gen grouplabpos = 0.1  /*location of outcome labels*/
gen stratalabpos = 0.1
gen lowerpos = 0.5
gen higherpos = 1
local xlabticks "0.5 1 2.5 5 10 20"
local xscalemax 70
local legendtext "order(1 3) label(1 "RR Pre-pandemic") label(3 "RR During Wave 1")"
local size1 "tiny"
local size2 "tiny"


	qui summ obs
	local ymax = r(max)
	di "ymax: `ymax'"

	/*******************************************************************************
	#draw graph
	*******************************************************************************/
	
	graph twoway ///
	/// irr and cis (pre-pandemic)
	|| scatter obs irr if irrtype == 1, msymbol(smtriangle) msize(`size1') mcolor(purple) 		/// data points 
		xline(1, lp(solid) lw(vthin) lcolor(black))				/// add ref line
	|| rcap lci uci obs if irrtype == 1, horizontal lw(vthin) col(black) msize(`size2')		/// add the CIs
	/// irr and cis (during pandemic)
	|| scatter obs irr if irrtype == 2, msymbol(smsquare) msize(`size1') mcolor(dkorange) 		/// data points 
	|| rcap lci uci obs if irrtype == 2, horizontal lw(vthin) color(black) msize(`size2')	/// add the CIs	
	/// add results labels
	|| scatter obs irrlabpos, m(i) mlab(result) mlabcol(black) mlabsize(`size2') mlabposition(3)  ///
	/// add p values
	|| scatter obs plabpos if irrtype == 1, m(i) mlab(intpstring) mlabcol(black) mlabsize(`size2') mlabposition(3) ///
	/// The outcome and exposure labels added back in 17th March
	|| scatter obs grouplabpos if grouplabrow == 1, m(i) mlab(grouplabel) mlabcol(black) mlabsize(`size2')  ///
	|| scatter obs stratalabpos if stratalabrow == 1, m(i) mlab(stratalabel) mlabcol(black) mlabsize(`size2') ///
	/// Headings for outcome labels and results
	|| scatter obs plabpos if obs==$headingobs, m(i) mlab(pheading) mlabcol(black) mlabsize(`size2') mlabpos(3) ///
	|| scatter obs irrlabpos if obs==$headingobs, m(i) mlab(irrheading) mlabcol(black) mlabsize(`size2') mlabpos(3) ///
	|| scatter obs lowerpos if obs==$headingobs, m(i) mlab(lowerriskheading) mlabcol(black) mlabsize(`size2') mlabpos(3) ///
	|| scatter obs higherpos if obs==$headingobs, m(i) mlab(higherriskheading) mlabcol(black) mlabsize(`size2') mlabpos(3) ///
	/// graph options
			, ///
			xtitle("RR (95% CI)", size(`size2') margin(0 2 0 0)) 	/// x-axis title - legend off
			xlab(`xlabticks', labsize(`size2') tlength(0.5cm)) /// x-axis tick marks
			xscale(range(1 `xscalemax') log)					///	resize x-axis
			, ylab(none) ytitle("") yscale(r(1 `ymax') off) ysize(8) /// y-axis no labels or title
			graphregion(color(white)) /// get rid of rubbish grey/blue around graph
			legend(`legendtext'  /// legend (1 = first plot, 3 = 3rd plot, 5 = 5th plot)
			size(`size2') rows(1) nobox region(lstyle(none) col(none) margin(zero)) bmargin(zero) pos(5)) ///
			name(`type', replace)
	pause
	
	graph export "$resultdir\an_glm_graphs_`type'_all_`database'_`linkage'.emf", replace

}



	

*graph combine stratalabs preduring pan inter, rows(1) xsize(11.0) ysize(6.2) imargins(tiny)

*

*graph combine binary lifedemo, rows(1) xsize(11.5) ysize(8.0) imargins(zero) graphregion(color(white))

graph display binarylifedemo, xsize(7.8) margins(zero) /*xsize was 7.8*/
graph export "$resultdir\an_glm_graphs_main_`agegp'_`database'_`linkage'.emf", replace


graph drop _all

foreach type in binarylifedemo cancer {
	erase "$datadir\temp_`type'.dta"
	}

capture log close


