capture log close
args database linkage

/*******************************************************************************
ESTIMATE TIME SERIES DATA
*******************************************************************************/
log using "$logdir\an_glm_estimates_lifestyle_`database'_`linkage'.txt", text replace


foreach strata in bmi smoking {

	*highest substrata
	if "`database'" == "combined" {
		use "$datadir\cr_weeklycounts_`strata'_99_aurum_`linkage'.dta", clear
		count
		append using "$datadir/cr_weeklycounts_`strata'_99_gold_`linkage'"
		count
		}
		else {
			use "$datadir/cr_weeklycounts_`strata'_99_`database'_`linkage'", clear
			}
	gen substrata = 99

	*remaining substrata
	if "`strata'" == "smoking" local i = 2
	if "`strata'" == "bmi" local i = 5
	
	forvalues x = 0/`i' {
	 
	if "`database'" == "combined" {
		append using "$datadir\cr_weeklycounts_`strata'_`x'_aurum_`linkage'.dta"
		append using "$datadir/cr_weeklycounts_`strata'_`x'_gold_`linkage'"
		} /*combined*/
		else {
			append using "$datadir/cr_weeklycounts_`strata'_`x'_`database'_`linkage'"
			} /*else*/
		
		replace substrata = `x' if substrata == .
		} /*forvalues*/
	
	if "`strata'" == "bmi" {
		replace substrata = 4 if substrata == 5 /*combine highest 2 categories*/
	}
	
	rename substrata `strata'
	local group = "lifestyle"
	local strata = "`strata'"

	tab `strata', m
	
	collapse (sum) deaths denominator, by(year week agestratum genderstratum `strata') /*HS added 23rd April 2021*/
	
	include "$dodir\inc_an_glm_estimates.do"

	} /*strata*/


capture log close
