capture log close
args database linkage

/*******************************************************************************
ESTIMATE TIME SERIES DATA
*******************************************************************************/
log using "$logdir\an_glm_estimates_demographics.txt", text replace


if "`database'" == "combined" {
	use "$datadir/cr_weeklycounts_region_gold_`linkage'", clear
	append using "$datadir/cr_weeklycounts_region_aurum_`linkage'"
	}
	else {
		use "$datadir/cr_weeklycounts_region_`database'_`linkage'", clear
		}
replace region = 4 if region == 6 /*combine East midlands with East of England*/

tempfile temp
save `temp'


/*study population*/

collapse (sum) deaths denominator, by(year week agestratum genderstratum)
gen studypop = 1
	
local group = "demographics"
local strata = "studypop"
	
include "$dodir\inc_an_glm_prepare.do"
drop if year == 2020 & week > $wave1end

local i=10
glm deaths year_c year_c2 sin* cos* ib`i'.agestr ib2.gender i.pandemic, family(nb ml) link(log) exposure(denominator) eform base
estimates save "$estimatedir\an_glm_estimates_`group'_`strata'_all_`database'_`linkage'", replace
pause

if "`database'" == "combined" & "`linkage'" == "primary" {

	glm deaths year_c year_c2 sin* cos* ib`i'.agestr i.pandemic if gender == 1, family(nb ml) link(log) exposure(denominator) eform base
	estimates save "$estimatedir\an_glm_estimates_`group'_`strata'_male_`database'_`linkage'", replace
	
	glm deaths year_c year_c2 sin* cos* ib`i'.agestr i.pandemic if gender == 2, family(nb ml) link(log) exposure(denominator) eform base
	estimates save "$estimatedir\an_glm_estimates_`group'_`strata'_female_`database'_`linkage'", replace

	local i = 11 /*base age stratum*/
	glm deaths year_c year_c2 sin* cos* ib`i'.agestr ib2.gender i.pandemic  if agestratum >=11, family(nb ml) link(log) exposure(denominator) eform base
	estimates save "$estimatedir\an_glm_estimates_demographics_studypop_old_`database'_`linkage'", replace 
	pause

	local i = 5
	glm deaths year_c year_c2 sin* cos* ib`i'.agestr ib2.gender i.pandemic if agestratum <11, family(nb ml) link(log) exposure(denominator) eform base
	estimates save "$estimatedir\an_glm_estimates_demographics_studypop_young_`database'_`linkage'", replace 
	pause

	}

/*regions*/
local group = "demographics"
local strata = "region"
use `temp', clear

collapse (sum) deaths denominator, by(year week agestratum genderstratum region)
include "$dodir\inc_an_glm_estimates.do"

local group = "demographics"
local strata = "london"
use `temp', clear

gen london = 0
replace london = 1 if region == 9
collapse (sum) deaths denominator, by(year week agestratum genderstratum london)
include "$dodir\inc_an_glm_estimates.do"

/*age groups*/
local group = "demographics"
local strata = "agestratum"
use `temp', clear
collapse (sum) deaths denominator, by(year week agestratum genderstratum)
include "$dodir\inc_an_glm_estimates.do"

use `temp', clear
collapse (sum) deaths denominator, by(year week agestratum genderstratum)
local strata = "agelinear" /*HS added 18th March 2021*/
include "$dodir\inc_an_glm_estimates.do"



/*sex*/
local group = "demographics"
local strata = "genderstratum"
use `temp', clear
collapse (sum) deaths denominator, by(year week agestratum genderstratum)
include "$dodir\inc_an_glm_estimates.do"


/*deprivation*/


if "`database'" == "combined" {
	use "$datadir/cr_weeklycounts_deprivation_gold_`linkage'", clear
	append using "$datadir/cr_weeklycounts_deprivation_aurum_`linkage'"
	}
	else {
		use "$datadir/cr_weeklycounts_deprivation_`database'_`linkage'", clear
		}

collapse (sum) deaths denominator, by(year week agestratum genderstratum deprivation)

local group = "demographics"
local strata = "deprivation"
include "$dodir\inc_an_glm_estimates.do"


/*rural urban*/
if "`database'" == "combined" {
	use "$datadir/cr_weeklycounts_urban_rural_gold_`linkage'", clear
	append using "$datadir/cr_weeklycounts_urban_rural_aurum_`linkage'"
	}
	else {
		use "$datadir/cr_weeklycounts_urban_rural_`database'_`linkage'", clear
		}
		
replace urban_rural = 1 if urban_rural == 3 /*mixed urban_rural in NI becomes urban = largest category*/
collapse (sum) deaths denominator, by(year week agestratum genderstratum urban_rural)


local group = "demographics"
local strata = "urban_rural"
include "$dodir\inc_an_glm_estimates.do"


/*ethnicity*/
if "`database'" == "combined" & "`linkage'" == "primary" local ethextra = "eth_lon eth_nonlon"
foreach strata in ethnicity `ethextra' {
	if "`database'" == "combined" {
		use "$datadir/cr_weeklycounts_`strata'_gold_`linkage'", clear
		append using "$datadir/cr_weeklycounts_`strata'_aurum_`linkage'"
		}
		else {
			use "$datadir/cr_weeklycounts_`strata'_`database'_`linkage'", clear
			}
	replace ethnicity = 3 if ethnicity == 4 /*include "mixed" in other*/
	if "`strata'" == "eth_lon" | "`strata'" == "eth_nonlon" rename ethnicity `strata'
	
	collapse (sum) deaths denominator, by(year week agestratum genderstratum `strata')
	
	local group = "demographics"

	include "$dodir\inc_an_glm_estimates.do"
	}
	


capture log close
