capture log close
args database linkage

/*******************************************************************************
ESTIMATE TIME SERIES DATA
*******************************************************************************/
log using "$logdir\an_glm_estimates_binary_`database'_`linkage'.txt", text replace

foreach strata in diab_perm cancer1yr neuro ra lupus psoriasis asthma ht ckd multimorbidity learning dementia chronicresp chronic_cardiac cerebrovascular vte  { /*removed immuno and liver*/
	if "`strata'" == "cancer1yr" {
		local group = "cancer"
		}
	else {
		local group = "binary"
		}

	*general population weekly counts
	if "`database'" == "combined" {
	use "$datadir/cr_weeklycounts_region_gold_`linkage'", clear
	append using "$datadir/cr_weeklycounts_region_aurum_`linkage'"
	}
	else {
		use "$datadir/cr_weeklycounts_region_`database'_`linkage'", clear
		}
		
	collapse (sum) deaths denominator, by(year week agestratum genderstratum)
	gen generalpop = 1
	
	*append strata weekly counts
	if "`database'" == "gold" | "`database'" == "aurum" {
		append using "$datadir/cr_weeklycounts_`group'_`strata'_`database'_`linkage'.dta"
		}

	if "`database'" == "combined" {
		tempfile temp
		save `temp', replace
	
		use "$datadir/cr_weeklycounts_`group'_`strata'_gold_`linkage'.dta", clear
		append using "$datadir/cr_weeklycounts_`group'_`strata'_aurum_`linkage'.dta"
		collapse (sum) deaths denominator, by(year week agestratum genderstratum)
		append using `temp'
		}
	
	*
	gen `strata' = 0
	replace `strata' = 1 if generalpop == .
	drop generalpop

	*subtract strata counts from general population counts
	bysort year week age gender (`strata'): egen _deathscov = min(deaths)
	bysort year week age gender (`strata'): egen _denomcov = min(denom)
	assert _deathscov <= deaths if `strata' == 0 /*there should be more deaths in the general pop*/

	list in 10000/10011
	replace deaths = deaths - _deathscov if `strata' == 0
	replace denominator = denominator - _denomcov if `strata' == 0
	list in 10000/10011
	drop _deathscov _denomcov
	
	include "$dodir\inc_an_glm_estimates.do"
	
	}

capture log close
