capture log close
args database linkage

/*******************************************************************************
ESTIMATE TIME SERIES DATA
*******************************************************************************/
log using "$logdir\an_glm_estimates_agesexinteractions.txt", text replace


if "`database'" == "combined" {
	use "$datadir/cr_weeklycounts_region_gold_`linkage'", clear
	append using "$datadir/cr_weeklycounts_region_aurum_`linkage'"
	}
	else {
		use "$datadir/cr_weeklycounts_region_`database'_`linkage'", clear
		}

tempfile temp
save `temp'

/*study population*/

local strata = "test"

collapse (sum) deaths denominator, by(year week agestratum genderstratum)
gen studypop = 1

include "$dodir\inc_an_glm_prepare.do"
drop if week == 2000 & week > $wave1end

glm deaths year_c year_c2 sin* cos* ib5.agestr ib2.gender i.pandemic, family(nb ml) link(log) exposure(denominator) eform /*iterate(100)*/
estimates store nointeractions

glm deaths year_c year_c2 sin* cos* ib5.agestr ib2.gender ib5.agestr##i.pandemic, family(nb ml) link(log) exposure(denominator) eform /*iterate(100)*/
estimates store ageinteractions

lrtest nointeractions ageinteractions


glm deaths year_c year_c2 sin* cos* ib5.agestr ib2.gender ib2.gender##i.pandemic, family(nb ml) link(log) exposure(denominator) eform /*iterate(100)*/
estimates store sexinteractions

lrtest nointeractions sexinteractions

/*CONCLUSION INCLUDE SEX INTERACTION BUT NOT AGE INTERACTION*/


capture log close
