
capture log close
args database linkage

log using "$logdir\an_denominatorsovertime_`database'_`linkage'.txt", text replace

/*******************************************************************************
GRAPHS DISPLAYING DENOMINATORS OVER TIME
*******************************************************************************/

foreach strata in studypop cancer1yr diab_perm ckd ht chronic_cardiac cerebrovascular vte asthma chronicresp ra psoriasis learning neuro dementia multimorbidity  { /*removed immuno and liver*/

	di as yellow "`strata'"
	
	if "`strata'" == "cancer1yr" {
		local group = "cancer"
		}
		else {
			local group = "binary"
			}
	
	include "$dodir\inc_an_denominatorsovertime.do"
	}

graph combine studypop cancer1yr diab_perm ckd ht chronic_cardiac cerebrovascular vte asthma chronicresp ra psoriasis learning neuro dementia multimorbidity, xsize(11.0) ysize(6.2) imargins(tiny)

graph export "$resultdir\an_denominatorsovertime_binary_`database'_`linkage'.emf", replace

foreach strata in cancer1yr cancer3mo cancer3mo1yr haemever nonhaemever haem1yr nonhaem1yr haem5yr nonhaem5yr  {
	
	local group = "cancer"

	include "$dodir\inc_an_denominatorsovertime.do"
}

graph combine cancer1yr cancer3mo cancer3mo1yr haemever nonhaemever haem1yr nonhaem1yr haem5yr nonhaem5yr, xsize(11.0) ysize(6.2) imargins(tiny)
graph export "$resultdir\an_denominatorsovertime_cancer_`database'_`linkage'.emf", replace

x

*ANALYSES BELOW WERE USED FOR TROUBLE SHOOTING

*add `group' to graph name and combine command in include file to make this work
local database = "aurum"
local linkage = "primary"

local group = "smoking"

forvalues strata = 0/2 {
	include "$dodir\inc_an_denominatorsovertime.do"
	}
local strata = 99
include "$dodir\inc_an_denominatorsovertime.do"

*graph combine bmi0 bmi1 bmi2 bmi3 bmi4 bmi5 bmi99, xsize(11.0) ysize(6.2) imargins(tiny)
graph combine smoking0 smoking1 smoking2 smoking99, xsize(11.0) ysize(6.2) imargins(tiny)
*graph combine ethnicity0 ethnicity1 ethnicity2 ethnicity3 ethnicity4 ethnicity99, xsize(11.0) ysize(6.2) imargins(tiny)

*individual strata

local group = "binary"
local strata = "immuno"

foreach database in gold aurum {
foreach linkage in primary linked {
	include "$dodir\inc_an_denominatorsovertime.do"
}
}

graph combine goldprimary aurumprimary goldlinked aurumlinked 


local group = "binary"
local database = "aurum"
local linkage = "primary"
local strata = "cerebrovascularlinkpop"
include "$dodir\inc_an_denominatorsovertime.do"


log close

