
library(ggplot2)
library(grid)
library(gridExtra)
library(rcompanion)
library(patchwork)

rm(list=ls())

#### Anonymise ###############################

Results_Q <- read.csv("./Q results/Results_Q.csv")
Results_Q$Type <- ifelse(grepl("Church", Results_Q$Building), "Church",
                         (ifelse(grepl("Clinic", Results_Q$Building), "Clinic", 
                                 ifelse(grepl("Shebeen", Results_Q$Building), "Shebeen",
                                        ifelse(grepl("Shop", Results_Q$Building), "Shop",
                                                      ifelse(grepl("Salon", Results_Q$Building), "Salon", ""))))))
Results_Q <- Results_Q  [,-c(2)]

write.csv(Results_Q, "./Q results/Results_Q.csv")
############################### 

############################### Plot ###############################

Results_Q <- read.csv("./Q results/Results_Q.csv")

Q_Church <- Results_Q[which(Results_Q$Type == 'Church'),]
Q_Clinic <- Results_Q[which(Results_Q$Type == 'Clinic'),]
Q_Salon <- Results_Q[which(Results_Q$Type == 'Salon'),]
Q_Shebeen <- Results_Q[which(Results_Q$Type == 'Shebeen'),]
Q_Shop <- Results_Q[which(Results_Q$Type == 'Shop'),]

##### Church #####
Church.Plot <- ggplot(Q_Church, aes(x=Building, y = Q, color = Type)) +
  geom_point(size = 0.7) + 
  theme_classic()+
  scale_colour_manual(name = Q_Church$Type, values=c("Shop" = "darkorange3", "Shebeen" = "green4", "Church" = "blue4", "Daycare" = "cyan3", "Salon" = "goldenrod2", "Clinic" = "#bb2900")) +
  ggtitle ("Church") + ylab ("Q (l/s)") +
  theme(plot.title = element_text(size = 10))+
  theme(axis.title.x = element_blank()) +
  theme(axis.text=element_text(size=8),
        axis.title=element_text(size=10)) +
  theme(axis.text.x = element_text(angle = 90, vjust = 0.5, hjust=1)) +
  theme(legend.position = "none") + 
  geom_errorbar(aes(ymin= CI1, ymax= CI2), width = 0.5)

##### Clinic #####
Clinic.Plot <- ggplot(Q_Clinic, aes(x=Building, y = Q, color = Type)) +
  geom_point(size = 0.7) + 
  theme_classic()+
  ggtitle ("Clinic")+
  theme(plot.title = element_text(size = 10)) +
  scale_colour_manual(name = Q_Church$Type, values=c("Shop" = "darkorange3", "Shebeen" = "green4", "Church" = "blue4", "Daycare" = "cyan3", "Salon" = "goldenrod2", "Clinic" = "#bb2900")) +
  theme(axis.title.x = element_blank()) +
  theme(axis.title.y = element_blank()) +
  theme(axis.text=element_text(size=8),
        axis.title=element_text(size=10)) +
  theme(axis.text.x = element_text(angle = 90, vjust = 0.5, hjust=1)) +
  theme(legend.position = "none") + 
  geom_errorbar(aes(ymin= CI1, ymax= CI2), width = 0.5)

##### Salon #####
Salon.Plot <- ggplot(Q_Salon, aes(x=Building, y = Q, color = Type)) +
  geom_point(size = 0.7) + 
  theme_classic()+
  scale_colour_manual(name = Q_Church$Type, values=c("Shop" = "darkorange3", "Shebeen" = "green4", "Church" = "blue4", "Daycare" = "cyan3", "Salon" = "goldenrod2", "Clinic" = "#bb2900")) +
  ggtitle ("Salon") + ylab("Q (l/s)") +
  theme(plot.title = element_text(size = 10)) + 
  theme(axis.title.x = element_blank()) +
  theme(axis.text=element_text(size=8),
        axis.title=element_text(size=10)) +
  theme(axis.text.x = element_text(angle = 90, vjust = 0.5, hjust=1)) +
  theme(legend.position = "none") + 
  geom_errorbar(aes(ymin= CI1, ymax= CI2), width = 0.5)

##### Shebeen #####
Shebeen.Plot <- ggplot(Q_Shebeen, aes(x=Building, y = Q, color = Type)) +
  geom_point(size = 0.7) + 
  theme_classic()+
  ggtitle ("Shebeen") + theme(plot.title = element_text(size = 10)) +
  scale_colour_manual(name = Q_Church$Type, values=c("Shop" = "darkorange3", "Shebeen" = "green4", "Church" = "blue4", "Daycare" = "cyan3", "Salon" = "goldenrod2", "Clinic" = "#bb2900")) +
  theme(axis.title.x = element_blank()) +
  theme(axis.title.y = element_blank()) +
  theme(axis.text=element_text(size=8),
        axis.title=element_text(size=10)) +
  theme(axis.text.x = element_text(angle = 90, vjust = 0.5, hjust=1)) +
  theme(legend.position = "none") + 
  geom_errorbar(aes(ymin= CI1, ymax= CI2), width = 0.5)

##### Shop #####
Shop.Plot <- ggplot(Q_Shop, aes(x=Building, y = Q, color = Type)) +
  geom_point(size = 0.7) + 
  theme_classic()+
  ggtitle ("Shop") + theme(plot.title = element_text(size = 10)) +
  scale_colour_manual(name = Q_Church$Type, values=c("Shop" = "darkorange3", "Shebeen" = "green4", "Church" = "blue4", "Daycare" = "cyan3", "Salon" = "goldenrod2", "Clinic" = "#bb2900")) +
  theme(axis.title.x = element_blank()) +
  theme(axis.title.y = element_blank()) +
  theme(axis.text=element_text(size=8),
        axis.title=element_text(size=10)) +
  theme(axis.text.x = element_text(angle = 90, vjust = 0.5, hjust=1)) +
  theme(legend.position = "none") + 
  geom_errorbar(aes(ymin= CI1, ymax= CI2), width = 0.5)


############################### 

(Church.Plot + Clinic.Plot + Salon.Plot) / (Shebeen.Plot + Shop.Plot) + 
  plot_annotation(title = 'Ventilation Rate') + theme(plot.title = element_text(size = 10))

##### Averages #####

sd <- by(Results_Q$Q,Results_Q$Type,sd)
sd_table <- as.data.frame.table(sd)

average_group <- groupwiseMean(
  data = Results_Q,
  var = "Q",
  group = "Type",
  R      = 10000,
  boot        = FALSE,
  traditional = FALSE,
  normal      = FALSE,
  basic       = FALSE,
  percentile  = FALSE,
  bca         = FALSE)

average_group_CI1 <- groupwiseMean(
  data = Results_Q,
  var = "CI1",
  group = "Type",
  R      = 10000,
  boot        = FALSE,
  traditional = FALSE,
  normal      = FALSE,
  basic       = FALSE,
  percentile  = FALSE,
  bca         = FALSE)

average_group_CI2 <- groupwiseMean(
  data = Results_Q,
  var = "CI2",
  group = "Type",
  R      = 10000,
  boot        = FALSE,
  traditional = FALSE,
  normal      = FALSE,
  basic       = FALSE,
  percentile  = FALSE,
  bca         = FALSE)

names(average_group_CI1)[names(average_group_CI1)=="Mean"] <- "CI1"
names(average_group_CI2)[names(average_group_CI2)=="Mean"] <- "CI2"
names(sd_table)[names(sd_table)=="Freq"] <- "sd"

average_type <- cbind(average_group, average_group_CI1, average_group_CI2, sd_table)
average_type <- average_type[,-c(2,4,5,7,8,10)]

write.csv(average_type, "./Q results/Results_Q_average.csv" )

ggplot(average_type, aes(x=Type, y = Mean, color = factor(Type))) +
  geom_point(size = 0.7) +
  theme_classic()+
  scale_colour_manual(name = Results_Q$Type, values=c("Shop" = "darkorange3", "Shebeen" = "forestgreen", "Church" = "blue4", "Salon" = "gold2", "Clinic" = "#bb2900")) +
  ggtitle ("Ventilation Rate by Building Type") + ylab ("Q (l/s)") +
  theme(axis.title.x = element_blank()) +
  theme(axis.text=element_text(size=8), 
        axis.title=element_text(size=10)) +
  theme(axis.text.x = element_text(angle = 90, vjust = 0.5, hjust=1)) +
  theme(legend.position = "none") + 
  geom_errorbar(aes(ymin= CI1, ymax= CI2), width = 0.5)

####################



