/*******************************************************************************
*
* Replication of Tougher et al (2018)
* 	
* 	FIGURE S4: Robustness check using external clusters as comparison group
*
*	FIGURE S5: obustness check using internal clusters as comparison group 
*
*   Last updated 10/06/2018 by ST
*
*******************************************************************************/

/*******************************************************************************
* TABLE OF CONTENTS
*
* 1. LOADING DATA SET 
* 2. ESTIMATING THE EFFECT OF SOCIAL FRANCHISING SUMMARY INDEXES (FOR EACH ROBUSTNESS CHECK)
* 3. PRODUCING AND SAVING FIGURES
*	3.1 Figure S4 (external controls only)
* 	3.2 Figure S5 (internal controls only)
*
*******************************************************************************/

* SECTION 1 - LOADING DATA SET
cd "$master\analysis\output"
use "$master\build\output\master_data_complete.dta", clear

* SECTION 2 - ESTIMATING THE EFFECT OF SOCIAL FRANCHISING  UMMARY INDEXES (FOR EACH ROBUSTNESS CHECK)
 foreach chk of global robust {
 
	foreach mod of global modelsimple_`chk'{
		foreach var of global indices_finalPt1_`chk'{
			`mod'
			estimates store `var'
		} 
 }

	use "$master\build\output\master_data_complete_all_births.dta", clear
	foreach mod of global modelsimple_`chk'{
		foreach var in ind_pp3_z_`chk'_final{
			`mod'
			estimates store `var'
	}
 }

 
	use "$master\build\output\master_data_complete.dta", clear

	foreach mod of global modelsimple_`chk'{
		foreach var of global indices_finalPt2_`chk' {
			`mod'
			estimates store `var'
		} 
 } 
 }

* SECTION 3 - PRODUCING AND SAVING THE FIGURES

** 3.1 Figure S4 (external controls only)
coefplot $indices_final_rob4, keep(aftXint) aseq swapnames legend(off) nooffsets ///
	xline(0) ciopts(recast(rcap) lcolor(dknavy))  mcolor(dknavy) xscale(r(-0.3 0.3)) ///
	xlabel(-0.5(0.1)0.5) 
graph save FigureS4, replace 

** 3.2 Figure S5 (internal controls only)
coefplot $indices_final_rob3, keep(aftXint) aseq swapnames nooffsets legend(off) ///
	xline(0) ciopts(recast(rcap) lcolor(dknavy))  mcolor(dknavy) xscale(r(-0.3 0.3)) ///
	xlabel(-0.5(0.1)0.5) 
graph save FigureS5, replace


		 