capture log close
clear all
set more off, perm
set matsize 400
version 14.1
set maxvar 3000

/******************************************************************************* 
* 
* Replication files for:
*	Tougher et al.  "Effect of a multifaceted social franchising model on quality 
*		and coverage of maternal, newborn, and reproductive health-care services 
*		in Uttar Pradesh, India: a quasi-experimental study." The Lancet Global 
*		Health. (2018)
*
*	http://www.thelancet.com/journals/langlo/article/PIIS2214-109X(17)30454-0/fulltext			
* 
* MASTER DO FILE - ANALYSIS
*
* Last updated 01/04/2018 by ST
*
*******************************************************************************/

/*******************************************************************************
* TABLE OF CONTENTS
*
* 1. NOTES
* 	1.1	Description
* 	1.2 Steps to run the file
*	1.3 Discrepancies between the replication files and journal article
* 2. SET PATH
* 3. RUN DO FILES FOR PREPARING DATA
*	3.1 Declare macros
*	3.2 Data management
* 4. RUN DO FILES FOR TABLES AND FIGURES
*	4.1 Table 1 & Table S1
*	4.2 Table 2, Table 3, Table 4: all columns except for FWER-adjusted p-values
*	4.3 Table 2, Table 3, Table 4: FWER-adjusted pvalues only
*	4.4 Figure 3		
*	4.5 Table S3, Table S4, Table S4: all columns except for FWER-adjusted p-values
*	4.6 Table S3, Table S4, Table S4: FWER-adjusted p-values
*	4.7 Figure S3
*	4.8 Figure S4 and Figure S5					 
*
********************************************************************************

* SECTION 1. NOTES 

** 1.1 Description

This code replicates tables from Tougher et al (2018). Tables and Figures 
replicated are:

		Table 1:	Baseline characteristics of women who gave birth before the 
					start of the intervention
		Table 2:	Estimated effect of the Matrika programme on antenatal care 
					outcomes
		Table 3:	Estimated effect of the Matrika programme on delivery care 
					outcomes
		Table 4:	Estimated effect of the Matrika programme on post-partum and 
					newborn outcomes
		Figure 3:	Effect of the Matrika programme on summary measures of 
					outcomes
		Table S1:	Outcomes at baseline
		
		Table S3:	Robustness checks of the effect of Matrika on ANC outcomes 
		
		Table S4:	Robustness checks of the effect of Matrika on delivery care 
					outcomes
		Table S5:	Robustness checks of the effect of Matrika on postpartum and 
					newborn outcomes
		Figure S3:	Common trends (leads and lags) for facility births
		
		Figure S4:	Robustness check using external clusters as comparison group
		
		Figure S5:	Robustness check using internal clusters as comparison group 

The code required to generate the tables and figures is divided among several .do 
files, which are called by this master file.

** 1.2 Steps to run the file

1) 	Ensure that you have the following user-written commands installed:
		-excelcol
		-fdsrmxt [fdsrmxt.ado must be obtained from the study author] 
		-coefplot

2) 	Save the Matrika_Rep folder to the directory of your choosing. This folder 
	contains all subfolders required to run the analysis.

3) 	Set the directory in Section 2 of this do file. The path specified should 
	include the folder structure up to Matrika_Rep 

4) 	If there is a specific table that you do not wish to replicate, you may 
	"comment out" the .do file that corresponds to the table. To comment out a 
	.do file, place an * at the start of the do command that precedes the file 
	name. (E.g. placing an * in front of 'do 03_baseline_covar_balance.do' in 
	Section 4 would mean that Table 1 would not be produced when running this 
	file.  
			
	Two sets of tables (Tables 2, 3 and 4 and Tables S3, S4 and S5) include p-values 
	that are adjusted for the family-wise error rate (FWER). It takes considerable 
	computing time to replicate the FWER-adjusted p-values in Tougher et al. You 
	may wish to "comment out" the two do files where the adjusted p-values are 
	produced (04b_FWER_adjust.do and 07b_FWER_adjust_checks.do). Alternatively, 
	follow Step 5 for instructions on how to reduce the runtime required for the 
	multiple-inference adjustment.
	
5) 	The number of iterations to produce the FWER-adjusted pvalues is set in the 
	file 01_macros.do. To change the number of iterations, open 01_macros.do 
	(which is located in the subfolder \analysis\code), and search for 'global 
	reps'. This is set to 10000 iterations for replication. Lowering this number 
	will improve runtime. Only the FWER-adjusted pvalues will be affected by this
    change. 
*/

** 1.3 Discrepencies between the replication files and journal article

/* There are a small differences between the tables that are automatically outputted 
	from these files, and the final tables in the published paper. These differences 
	are the result of small changes to the format of the tables, and are not errors. 
	The differences are as follows: 


1. 	Tables generated from these analysis files are outputted into excel. Means and 
	treatment effects are rounded to 0 decimal places in the excel files. Means 
	and treatment effects for continuous outcomes were rounded to two decimal places 
	in the final published paper. However, results from stata are exported to 
	excel with greater accuracy, so other rounding conventions may be used.  

	
2. Table 1: The columns with the heading 'intervention' and 'control' contain 
			n (%) in the published paper, but % only in the replication files 
			(for the binary indicators). This reflects a change in formatting, 
			not an error. 
			
3. Tables 2-4: The output produced from the replication files is in a different 
			format than the published paper. The first 4 columns in the paper 
			show n/N (%) or mean (sd), but the output of the   
			 */
 			
			
* SECTION 2: SET PATH  
/*	Set your directory here. The path specified should include your folder 
	structure up to Matrika_Rep */
	
global master "C:\Sync\My Files\Sync\Projects\MET\Matrika\Matrika_Rep\"

* SECTION 3: RUN DO FILES TO PREPARE DATA 

** 3.1 Declare macros  

/* All global macros used in the analysis are defined in this do file. The globals 
serve several functions, such as:  
	-group individual outcomes into domains
    -create lists of variables included as controls
	-set the analysis models
	-set seed and number of iterations for computing the FWER-adjusted p-values
	-set font for the output tables */
	
cd "$master\analysis\temp"
log using 01_macros, replace 

cd "$master\analysis\code"
do 01_macros.do

log close

** 3.2 Data management

/* Various data management is completed in this file. Including:
	-appending data sets from two rounds of data collection
	-creating variables in the appended data sets 
		(Note, variables created in this file are variables that needed to be 
		constructed from the appended data sets. Variables (e.g. the individual 
		study outcomes were created in separate data management files for each 
		round of data collection.)
	-labelling variables */

cd "$master\analysis\temp"
log using 02_data_management, replace

cd "$master\analysis\code"
do 02_data_management.do

log close

* SECTION 4: RUN DO FILES FOR MAIN TABLES AND FIGURES

** 4.1 Table 1 & Table S1

/* Produces table of baseline characteristics of women who gave birth before 
	the start of the intervention */
cd "$master\analysis\temp"
log using 03_table1&S1, replace

	
cd "$master\analysis\code"
do 03_table1&S1.do

log close


** 4.2 Tables 2, 3 & 4
cd "$master\analysis\temp"
log using 04_tables2_4, replace

cd "$master\analysis\code"
do 04_tables2_4.do

log close


** 4.3 FWER-adjusted p-values for Tables 2, 3 & 4
cd "$master\analysis\temp"
log using 05_fwer, replace

cd "$master\analysis\code"
do 05_fwer_adjust.do

log close


** 4.4 Figure 3
cd "$master\analysis\temp"
log using 06_Figure3, replace

cd "$master\analysis\code"
do 06_Figure3.do

log close


** 4.5 Tables S3, S4 & S5
cd "$master\analysis\temp"
log using 07_tablesS3_S5, replace

cd "$master\analysis\code"
do 07_tablesS3_S5.do

log close


** 4.6 FWER-adjusted p-values for Tables S3, S4 & S5
cd "$master\analysis\temp"
log using 08_fwer_adjust, replace

cd "$master\analysis\code"
do 08_fwer_adjust.do

log close


** 4.7 Figure S3
cd "$master\analysis\temp"
log using 09_leads_and_lags, replace

cd "$master\analysis\code"
do 09_leads_and_lags.do

log close


** 4.8 Figures S4 & S5
cd "$master\analysis\temp"
log using 10_FiguresS4&S5, replace

cd "$master\analysis\code"
do 10_FiguresS4&S5.do

log close

 
